import win32gui

def get_all_windows():
    hwnd_title = {}
    def callback(hwnd, hwnd_title):
        if win32gui.IsWindow(hwnd) and win32gui.IsWindowEnabled(hwnd):
            title = win32gui.GetWindowText(hwnd)
            if title != "":
                hwnd_title[title] = hwnd
    win32gui.EnumWindows(callback, hwnd_title)
    return hwnd_title

#返回标题内包含title的窗口句柄
def get_window_by_title(title=""):
    for htitle, hwnd in get_all_windows().items():
        if htitle.find(title) > -1:
            return hwnd
    return None

def get_children_window(parent):
    hwndChildList = []
    win32gui.EnumChildWindows(parent, lambda hwnd, param: param.append(hwnd), hwndChildList)
    return hwndChildList

hwnd = get_window_by_title("EVA - Willkommensseite")
print(hwnd)
child_list = get_children_window(hwnd)
print(child_list)