from selenium import webdriver
from selenium.webdriver.common.by import By
from selenium.webdriver.support.wait import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC
from selenium.webdriver.common.actions.action_builder import ActionBuilder
from selenium.webdriver import Keys, ActionChains
from pynput.keyboard import Key, Controller as KeyController
from pynput.mouse import Controller as MouseController, Button
import os
import json
import time
import win32api, win32gui, win32ui, win32con
import subprocess
import cv2
import numpy as np
from PIL import Image
import xmltodict
import rapidocr_onnxruntime 
#配置信息
configs = {
    "userName": "D8QUANS1",
    "password": "ZHAOXIULI598302@",
    "inputFile": "FinList.txt",
    "indexFile": "currentFin.txt",
    "outputFile": "result.xls",
    "timeOutOne": 3,
    "checkTimes": 10,
    "queryInterval": 5,
    "javaws" : "C:\\ProgramData\\Oracle\\Java\\javapath\\javaws.exe",
    "offset": {
        "SecurityAlert": [[43,346],[391,344]],
        "StartApp":[123,123],
        "WelcomePage":[35,291],
        "Details":[530,97],
        "Input":[320,82],
        "Status":[297,82],
        "Results":[224,394],
        "SystemMenu":[17,37],
        "ExportXls":[46,175]
    }
}
#FIN号码列表
finListArray = []
#当前处理到的FIN号码
current_fin = ""
#鼠标键盘模拟操作控制器
keyboard = KeyController()
mouse = MouseController()
#车辆信息页面窗口的位置
main_rect = {}
#返回标题不为空的所有窗口
def get_all_windows():
    hwnd_title = {}
    def callback(hwnd, hwnd_title):
        if win32gui.IsWindow(hwnd) and win32gui.IsWindowEnabled(hwnd):
            title = win32gui.GetWindowText(hwnd)
            if title != "":
                hwnd_title[title] = hwnd
    win32gui.EnumWindows(callback, hwnd_title)
    return hwnd_title

#返回标题内包含title的窗口句柄
def get_window_by_title(title=""):
    for htitle, hwnd in get_all_windows().items():
        if htitle.find(title) > -1:
            return hwnd
    return None

#激活标题包含title的窗口，设置为前端显示
def active_window_by_title(title=""):
    if title!="":
        hwnd = get_window_by_title(title)
        if hwnd != None:
            win32gui.ShowWindow(hwnd,4)
            win32gui.SetForegroundWindow(hwnd)

# 获取标题是title的窗口的坐标
def get_rect_for_title(title=""):
    # 找到窗口的句柄
    if title!="":
        hwnd = win32gui.FindWindow(None, title)
    if not hwnd:
        raise Exception("Window not found!")
    # 获取窗口的坐标
    rect = win32gui.GetWindowRect(hwnd)
    return rect

# 获取标题包含title的窗口坐标
def get_rect_by_title(title=""):
    if title!="":
        hwnd = get_window_by_title(title)
        if hwnd != None:
            return win32gui.GetWindowRect(hwnd)

# 获取句柄是hwnd的窗口坐标
def get_rect_by_hwnd(hwnd):
    if hwnd!=None:
        return win32gui.GetWindowRect(hwnd)

# 通过窗口句柄截取当前句柄图片 返回cv2格式的Mat数据
def window_capture(hwnd, picture_name=None):
    x1, y1, x2, y2 = win32gui.GetWindowRect(hwnd)  # 获取当前窗口大小
    hwndDC = win32gui.GetWindowDC(hwnd)  # 通过应用窗口句柄获得窗口DC
    mfcDC = win32ui.CreateDCFromHandle(hwndDC)  # 通过hwndDC获得mfcDC(注意主窗口用的是win32gui库，操作位图截图是用win32ui库)
    neicunDC = mfcDC.CreateCompatibleDC()  # 创建兼容DC，实际在内存开辟空间（ 将位图BitBlt至屏幕缓冲区（内存），而不是将屏幕缓冲区替换成自己的位图。同时解决绘图闪烁等问题）
    savebitmap = win32ui.CreateBitmap()  # 创建位图
    width = x2 - x1
    height = y2 - y1
    savebitmap.CreateCompatibleBitmap(mfcDC, width, height)  # 设置位图的大小以及内容
    neicunDC.SelectObject(savebitmap)  # 将位图放置在兼容DC，即 将位图数据放置在刚开辟的内存里
    neicunDC.BitBlt((0, 0), (width, height), mfcDC, (0, 0), win32con.SRCCOPY)  # 截取位图部分，并将截图保存在剪贴板
    if picture_name is not None:
        savebitmap.SaveBitmapFile(neicunDC, picture_name)  # 将截图数据从剪贴板中取出，并保存为bmp图片
        img_buf = savebitmap.GetBitmapBits(True)
        img = np.frombuffer(img_buf, dtype="uint8")
        img.shape = (height, width, 4)
        mat_img = cv2.cvtColor(img, cv2.COLOR_RGB2RGBA)  # 转换RGB顺序
        cv2.imwrite(picture_name.replace(".bmp",".jpg"), img)
    # 释放内存
    win32gui.DeleteObject(savebitmap.GetHandle())
    neicunDC.DeleteDC()
    mfcDC.DeleteDC()
    win32gui.ReleaseDC(hwnd, hwndDC)

# 获取屏幕指定位置的颜色
def get_pixel_color(x, y):
    pixel = win32gui.GetPixel(win32gui.GetWindowDC(None), x, y)
    r = pixel & 0x0000ff
    g = (pixel & 0x00ff00) >> 8
    b = pixel >> 16
    return "%02x%02x%02x" %(r,g,b)

#ocr识别图片文字和位置
def Image_Ocr(image=""):
    config_path = os.path.join(os.path.dirname(rapidocr_onnxruntime.__file__),"config.yaml")
    model = rapidocr_onnxruntime.RapidOCR(config_path=config_path)
    image = Image.open(image)
    data, _ = model( image , use_det=True, use_cls=False, use_rec=True)
    # data: List[List[float], str, float] ([[左上, 右上, 右下, 左下], 文本内容, 置信度])
    return data

#设置浏览器参数
options = webdriver.ChromeOptions()
options.add_argument("--start-maximized")
options.add_argument("--user-data-dir=%s/chromedata" % (os.getcwd()))
# options.binary_location = chrome_bin
options.add_experimental_option("detach", True)
service = webdriver.ChromeService(log_output=subprocess.STDOUT)
driver = webdriver.Chrome(options=options,service=service)

# 打开网页
driver.get('https://xentry.mercedes-benz.com/login')
wait = WebDriverWait(driver, timeout=30)
#检查当前页面是否已经加载完成
wait.until(lambda d : driver.execute_script("return document.readyState")=="complete")
time.sleep(1)
#检查存在userid的input来判断是否已经登录
try:
    user_tip = driver.find_element(By.XPATH, "//label[@for='userid']")
    WebDriverWait(driver, timeout=10).until(lambda d : user_tip.is_displayed())
except Exception as e:
    #当前已经登录的需要先退出登录
    driver.execute_script('document.componentRegistry[24].logout()')
    # driver.get("https://login.mercedes-benz.com/signout")
    # 等待10秒，检查是否已经退出到 https://login.mercedes-benz.com/signout?loggedout=true
    WebDriverWait(driver, timeout=10).until(lambda d : driver.current_url.find("/signout?loggedout=true") > -1 )
    driver.get('https://xentry.mercedes-benz.com/login')

#等待登录界面加载
wait.until(lambda d : driver.title=="梅賽德斯-奔馳集團股份公司")
#active_window("梅賽德斯-奔馳集團股份公司")
time.sleep(1)
#等待用户名输入框并输入用户名
user_input = driver.find_element(By.ID, "userid")
wait.until(lambda d : user_tip.is_displayed())
ActionChains(driver)\
        .move_to_element(user_input)\
        .pause(1)\
        .click_and_hold()\
        .pause(1)\
        .send_keys(configs['userName' ])\
        .perform()
#点击下一步
driver.find_element(By.ID, "next-btn").click()
submit_btn = driver.find_element(By.ID, "loginSubmitButton")
wait.until(lambda d : submit_btn.is_displayed())
#等待密码输入框并输入密码
pass_input = driver.find_element(By.ID, "password")
ActionChains(driver)\
        .move_to_element(pass_input)\
        .pause(1)\
        .click_and_hold()\
        .pause(1)\
        .send_keys(userInfo['passwd'])\
        .perform()
time.sleep(1)
#点击登录按钮
submit_btn.click()

#检查并删除旧的evadrd.jnlp
downloaddir="%s/Downloads" % (os.environ['USERPROFILE'])
oldjnlps = [filename for filename in os.listdir(downloaddir) if filename.startswith('evadrd') and filename.endswith(".jnlp")]
for jnlp in oldjnlps:
    os.unlink( "%s/%s" % (downloaddir, jnlp) )

#下载新的evadrd.jnlp
time.sleep(5)
driver.execute_script('window.location.href="https://eva-aftersales.mercedes-benz.com/evadrd/appstarter/start/index.jsp";' )

def app_quit():
    # 不需要操作浏览器，关闭浏览器
    driver.quit()
    exit()

#设置eva web start窗口是否已经点击
is_eva_started = False

#窗口检测的等待次数，每次等待3秒，一共等待多少次就报告超时退出。
window_wait_times = 30
def run_jnlp():
    #等待30秒检查evadrd.jnlp是否下载完成
    jnlp = "%s/evadrd.jnlp" % (downloaddir)
    for i in range(15):
        if os.path.exists(jnlp):
            break
        else:
            time.sleep(2)
    if not os.path.exists(jnlp):
        print("evadrd.jnlp不存在")
        exit()
    #用javaws.exe打开evadrd.jnlp
    process = subprocess.Popen(['javaws.exe', jnlp ])
    is_eva_started = False
    window_wait_times = 30

#处理打开eva软件前的各种警告提示窗口
def detectWindows():
    windowLists = get_all_windows()
    print(windowLists)
    retry = True
    hwnd = get_window_by_title("Fehler - (")
    if hwnd != None:
        keyboard.tap(Key.enter)
        #每次窗口操作之后重置检测次数
        window_wait_times = 30
    else:
        if "安全信息" in windowLists:
            with keyboard.pressed(Key.alt):
                keyboard.press('d')
                keyboard.release('d')
            time.sleep(1)
            with keyboard.pressed(Key.alt):
                keyboard.press('r')
                keyboard.release('r')
            #每次窗口操作之后重置检测次数
            window_wait_times = 30
        elif "警告 - 请求的 Java 版本不可用" in windowLists:
            keyboard.tap(Key.enter)
        elif "Windows 安全中心警报" in windowLists:
            keyboard.tap(Key.enter)
            #每次窗口操作之后重置检测次数
            window_wait_times = 30
        elif "EVA PROD Webstart" in windowLists:
            #此处特殊处理，只需要点击一次即可，该窗口会一直存在。
            if is_eva_started==False:
                hwnd = windowLists["EVA PROD Webstart"]
                rect = get_rect_by_hwnd(hwnd)
                x = rect[0] + configs["offset"]["StartApp"][0]
                y = rect[1] + configs["offset"]["StartApp"][1]
                mouse.position = (x,y)
                mouse.press(Button.left)
                mouse.release(Button.left)
                is_eva_started=True
                #每次窗口操作之后重置检测次数
                window_wait_times = 30
        elif "EVA - Willkommensseite" in windowLists:
            errcode,results = subprocess.getstatusoutput('taskkill /F /FI "IMAGENAME eq javaw.exe"')
            APPDATA = os.environ['APPDATA']
            inistr=""
            with open( "%s/.eva-prod/userproperties.ini" % ( APPDATA ) , "r") as f:
                inistr = f.readall()
            inistr = inistr.replace("defaultLanguageValue=01","defaultLanguageValue=30")
            if inistr!="":
                with open( "%s/.eva-prod/userproperties.ini" % ( APPDATA ) , "w") as f:
                    f.write(inistr)
            run_jnlp()
        elif "EVA - 欢迎页" in windowLists:
            handleEVA()
            retry = False
            #每次窗口操作之后重置检测次数
            window_wait_times = 30
        else:
            #未找到上面的所有窗口，继续等待
            pass
    #等待次数递减，直到为0报超时退出
    window_wait_times -= 1
    if window_wait_times == 0:
        print("等待窗口出错，请人工检查")
        app_quit()
        return
    if retry:
        time.sleep(configs['timeOutOne'])
        detectWindows()

#打开eva软件的车辆信息页面
def handleDetail():
    hwnd = get_window_by_title("EVA - 车辆信息")
    if hwnd == None:
        return
    main_rect = get_rect_by_hwnd(hwnd)
    #计算车辆信息页面的 VIN输入框位置，并鼠标双击
    x = main_rect[0] + configs["offset"]["Details"][0]
    y = main_rect[1] + configs["offset"]["Details"][1]
    mouse.position = (x,y)
    mouse.click(Button.left, 2)

def checkFinFile():
    if os.path.exists(configs["inputFile"]):
        with open(configs["inputFile"], "r") as f:
            finListArray = f.read().split("\n")
    if os.path.exists( configs["indexFile"] ):
        with open(configs["indexFile"], "r") as f:
            current_fin = f.read().strip("\n")

#获取下一个Fin号码
def getOneVin():
    try:
        position = finListArray.index(current_fin)
    except ValueError:
        position = -1  #

    if position >-1 and position < len(finListArray)-1:
        current_fin = finListArray[position+1]
        return saveNextIndex()
    else:
        return False


def extractExport():
    xlsfile = "%s/Documents/故障编码表格Excel.xls" %b ( os.environ["USERPROFILE"])
    if os.path.exists( xlsfile) :
        with open(xlsfile,"rb") as f:
            xml_data = f.read().decode("utf-16")
        
        dict_data = xmltodict.parse(xml_data)
        json_data = json.dumps(dict_data)
        print(json_data)
        ##这里写自己的代码

    cleanTmpFile()

def saveExcel(){
    #导出表格
    active_window_by_title("导出表格")
    rect = get_rect_for_title("导出表格")
    x = rect[0] + configs['offset']["javaws"]["ExportXls"][0]
    y = rect[1] + configs['offset']["javaws"]["ExportXls"][1]

    mouse.position = (x,y)
    mouse.click(Button.left)

    time.sleep(configs['timeOutOne'])
    extractExport()

#鼠标点击展开系统菜单项,然后选择导出
def exportExcel():
    #
    x = main_rect[0] + configs['offset']["javaws"]["SystemMenu"][0]
    y = main_rect[1] + configs['offset']["javaws"]["SystemMenu"][1]
    mouse.click(Button.left)
    time.sleep(configs['timeOutOne'])
    keyboard.tap(Key.down)
    keyboard.tap(Key.enter)
    time.sleep(configs['timeOutOne'])
    saveExcel()

#循环configs['checkTimes']次等待查询结果框位置的颜色，根据颜色判断是否存在数据。
def queryResult( retryTimes ):
    if retryTimes >= 0:
        x = main_rect[0] + configs['offset']["javaws"]["Status"][0] 
        y = main_rect[1] + configs['offset']["javaws"]["Status"][1]

        colorA = get_pixel_color(x,y)
        if colorA != "000000" and colorA != "f4f4f9":
            time.sleep(configs['timeOutOne'])
            queryResult( retryTimes-1 )
        else:
            x = main_rect[0] + configs['offset']["javaws"]["Results"][0] 
            y = main_rect[1] + configs['offset']["javaws"]["Results"][1]
            colorB = get_pixel_color(x,y)
            if colorB =="ffffff":
                #未查询到数据，继续下一个Fin的号码查询
                saveNextIndex()
                time.sleep(configs['timeOutOne'])
                autoQuery()
            else:
                #查询到数据，导出excel
                exportExcel()
    else:
        app_quit()
        return

#双击输入框全选上次的Fin号码，然后输入新的Fin号码，然后回车查询
def autoQuery():
    x = main_rect[0] + configs['offset']["javaws"]["Input"][0] 
    y = main_rect[1] + configs['offset']["javaws"]["Input"][1]
    if getOneVin():
        vin = current_fin.substr(3)

    mouse.position = (x,y)
    mouse.click(Button.left, 2)
    time.sleep(1)
    keyboard.type(current_fin)
    time.sleep(1)
    queryResult( configs['checkTimes'] )


def saveNextIndex():
    with open(configs["indexFile"], "w") as f:
        f.write(current_fin)
        f.flush()
    return True

def cleanTmpFile():
    #清理缓存的临时文件
    if not os.path.exists("cleanTemp.bat"):
        with open("cleanTemp.bat","w") as f:
            f.write('cd "%USERPROFILE%\\Documents" && del /F /Q *Excel.xls *Access.xml *Access.xsd')
    errcode,results = subprocess.getstatusoutput('cmd.exe /C cleanTemp.bat')
    print(errcode,results)
    saveNextIndex()
    autoQuery()

def handleEVA():
    #计算鼠标点击左侧菜单项的 车辆信息 的位置，并鼠标单击
    hwnd = get_window_by_title("EVA - 欢迎页")
    if hwnd == None:
        return
    rect = get_rect_by_hwnd(hwnd)
    x = rect[0] + configs["offset"]["WelcomePage"][0]
    y = rect[1] + configs["offset"]["WelcomePage"][1]
    mouse.position = (x,y)
    mouse.press(Button.left)
    mouse.release(Button.left)
    handleDetail()

run_jnlp()
time.sleep(configs['timeOutOne'])
detectWindows()