import win32gui
 
def get_all_windows():
    hwnd_title = {}
    def callback(hwnd, hwnd_title):
        if win32gui.IsWindow(hwnd) and win32gui.IsWindowEnabled(hwnd):
            hwnd_title[hwnd] = win32gui.GetWindowText(hwnd)
    win32gui.EnumWindows(callback, hwnd_title)
    return hwnd_title
 
titles = get_all_windows()
for hwnd, title in titles.items():
    print(f'{hwnd}: {title}')