import win32gui
import win32ui
import win32con
import cv2
 
# 获取屏幕指定位置的颜色
def get_pixel_color(x, y):
    pixel = win32gui.GetPixel(win32gui.GetWindowDC(None), x, y)
    r = pixel & 0x0000ff
    g = (pixel & 0x00ff00) >> 8
    b = pixel >> 16
    return "%02x%02x%02x" %(r,g,b)

 
# 示例：获取屏幕坐标(100, 100)的颜色
x, y = 800, 100
color = get_pixel_color(x, y)
print(f"The color at ({x}, {y}) is: {color}")